/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.HwmcaParser;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.Task;
import com.ibm.hwmca.fw.managed.TaskChecker;
import com.ibm.hwmca.fw.managed.TaskGroup;
import com.ibm.hwmca.fw.managed.UserRole;
import com.ibm.hwmca.fw.ui.UIBook;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.ImageNodeData;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TaskDefinitionXML {
    private static final String TRACE_MASKT = "XFTDXMLT";
    private static final String TRACE_MASKF = "XFTDXMLF";
    private static final String TRACE_MASKD = "XFTDXMLD";
    private static ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
    private static ClassId taskClassId = new ClassId(class$com$ibm$hwmca$fw$managed$Task == null ? (class$com$ibm$hwmca$fw$managed$Task = TaskDefinitionXML.class$("com.ibm.hwmca.fw.managed.Task")) : class$com$ibm$hwmca$fw$managed$Task);
    private static ClassId taskgroupClassId = new ClassId(class$com$ibm$hwmca$fw$managed$TaskGroup == null ? (class$com$ibm$hwmca$fw$managed$TaskGroup = TaskDefinitionXML.class$("com.ibm.hwmca.fw.managed.TaskGroup")) : class$com$ibm$hwmca$fw$managed$TaskGroup);
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "TskDefintion");
    public static final short UPDATE_CHILD_ERROR = 1183;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$Task;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$TaskGroup;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$UserRole;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$ui$UIInfo;

    public static void add(String fileName) throws HException {
        Trace.trace(TRACE_MASKT, "-> TaskDefinitionXML.add()");
        Trace.trace(TRACE_MASKF, "   fileName is [" + fileName + "]");
        try {
            HashMap tasks = new HashMap();
            HashMap taskGroups = new HashMap();
            FileInputStream fis = new FileInputStream(fileName);
            Document doc = new HwmcaParser(fis, false).getDocument();
            TaskDefinitionXML.createTasks(doc, tasks);
            TaskDefinitionXML.createTaskGroups(doc, tasks, taskGroups);
            TaskDefinitionXML.createUserRoles(doc, tasks, taskGroups);
        }
        catch (Exception exc) {
            HException hexc = new HException(exc);
            String text = "TaskDefinitionXML.add(String)\ncaught Exception while processing XML file [" + fileName + "]";
            hexc.add(text);
            throw hexc;
        }
        Trace.trace(TRACE_MASKT, "<- TaskDefinitionXML.add()");
    }

    public static void remove(String fileName) throws HException {
        Trace.trace(TRACE_MASKT, "-> TaskDefinitionXML.remove()");
        Trace.trace(TRACE_MASKF, "   fileName is [" + fileName + "]");
        try {
            HashMap tasks = new HashMap();
            FileInputStream fis = new FileInputStream(fileName);
            Document doc = new HwmcaParser(fis, false).getDocument();
            TaskDefinitionXML.removeTaskGroups(doc, tasks);
            TaskDefinitionXML.removeTasks(doc, tasks);
        }
        catch (Exception exc) {
            HException hexc = new HException(exc);
            String text = "TaskDefinitionXML.remove(String)\ncaught Exception while processing XML file [" + fileName + "]";
            hexc.add(text);
            throw hexc;
        }
        Trace.trace(TRACE_MASKT, "<- TaskDefinitionXML.remove()");
    }

    private static void createUserRoles(Document doc, HashMap tasks, HashMap taskGroups) throws HException {
        Trace.trace(TRACE_MASKT, "-> TaskDefinitionXML.createUserRoles()");
        NodeList nodes = doc.getElementsByTagName("rolegroup");
        for (int i = 0; i < nodes.getLength(); ++i) {
            UserRole role = null;
            String roleName = null;
            UIInfo roleUIInfo = null;
            Element permittedTaskObjects = null;
            Element permittedTaskGroups = null;
            Element permittedManagedObjects = null;
            String displayableFlag = "true";
            String editableFlag = "false";
            Element roleElement = (Element)nodes.item(i);
            if (roleElement.getAttribute("type").equals("addtasks")) {
                NodeList keys = roleElement.getElementsByTagName("key");
                if (keys.getLength() <= 0) continue;
                Node nextNode = keys.item(0);
                ObjectId objectId = new ObjectId((class$com$ibm$hwmca$fw$managed$UserRole == null ? TaskDefinitionXML.class$("com.ibm.hwmca.fw.managed.UserRole") : class$com$ibm$hwmca$fw$managed$UserRole).getName());
                objectId.setKeyProperty("Name", TaskDefinitionXML.getValue(nextNode));
                role = (UserRole)mom.get(objectId);
                NodeList children = roleElement.getElementsByTagName("managedobjects");
                if (children.getLength() > 0) {
                    nextNode = children.item(0);
                    TaskDefinitionXML.updateRoleManagedObjects(role, (Element)nextNode, true);
                }
                if ((children = roleElement.getElementsByTagName("tasks")).getLength() > 0) {
                    nextNode = children.item(0);
                    TaskDefinitionXML.updateRoleTasks(role, tasks, (Element)nextNode, true);
                }
                if ((children = roleElement.getElementsByTagName("taskgroups")).getLength() <= 0) continue;
                nextNode = children.item(0);
                TaskDefinitionXML.updateRoleTaskGroups(role, taskGroups, (Element)nextNode, true);
                continue;
            }
            NodeList roleChildNodes = roleElement.getChildNodes();
            for (int j = 0; j < roleChildNodes.getLength(); ++j) {
                Node nextNode = roleChildNodes.item(j);
                if (nextNode.getNodeType() != 1) continue;
                if (nextNode.getNodeName().equalsIgnoreCase("key")) {
                    roleName = TaskDefinitionXML.getValue(nextNode);
                    continue;
                }
                if (nextNode.getNodeName().equalsIgnoreCase("displayable")) {
                    displayableFlag = TaskDefinitionXML.getValue(nextNode);
                    continue;
                }
                if (nextNode.getNodeName().equalsIgnoreCase("editable")) {
                    editableFlag = TaskDefinitionXML.getValue(nextNode);
                    continue;
                }
                if (nextNode.getNodeName().equalsIgnoreCase("uiinfo")) {
                    roleUIInfo = TaskDefinitionXML.createUIInfo(nextNode);
                    continue;
                }
                if (nextNode.getNodeName().equalsIgnoreCase("tasks")) {
                    permittedTaskObjects = (Element)nextNode;
                    continue;
                }
                if (nextNode.getNodeName().equalsIgnoreCase("taskgroups")) {
                    permittedTaskGroups = (Element)nextNode;
                    continue;
                }
                if (!nextNode.getNodeName().equalsIgnoreCase("managedobjects")) continue;
                permittedManagedObjects = (Element)nextNode;
            }
            role = new UserRole(roleName, roleUIInfo);
            if (displayableFlag.equals("true") || displayableFlag.equals("yes")) {
                role.setDisplayable(true);
            } else {
                role.setDisplayable(false);
            }
            if (editableFlag.equals("true") || editableFlag.equals("yes")) {
                role.setEditable(true);
            } else {
                role.setEditable(false);
            }
            if (permittedTaskObjects != null) {
                TaskDefinitionXML.updateRoleTasks(role, tasks, permittedTaskObjects, true);
                if (permittedTaskGroups != null) {
                    TaskDefinitionXML.updateRoleTaskGroups(role, taskGroups, permittedTaskGroups, true);
                }
                role.setType(1);
            } else if (permittedManagedObjects != null) {
                role.setType(0);
                TaskDefinitionXML.updateRoleManagedObjects(role, permittedManagedObjects, true);
            } else {
                System.out.println("error in xml data received");
            }
            mom.add(role);
        }
        Trace.trace(TRACE_MASKT, "<- TaskDefinitionXML.createUserRoles()");
    }

    private static HashMap createTaskGroups(Document doc, HashMap tasks, HashMap taskGroups) throws HException {
        Trace.trace(TRACE_MASKF, "   -> TaskDefinitionXML.createTaskGroups()");
        NodeList nodes = doc.getElementsByTagName("taskgroup");
        for (int i = 0; i < nodes.getLength(); ++i) {
            TaskGroup group = null;
            String groupName = null;
            UIInfo groupUIInfo = null;
            Element groupChildren = null;
            String groupRoot = null;
            Element groupElement = (Element)nodes.item(i);
            if (groupElement.getAttribute("type").equals("addtasks")) {
                NodeList keys = groupElement.getElementsByTagName("key");
                if (keys.getLength() <= 0) continue;
                Node nextNode = keys.item(0);
                ObjectId objectId = new ObjectId((class$com$ibm$hwmca$fw$managed$TaskGroup == null ? TaskDefinitionXML.class$("com.ibm.hwmca.fw.managed.TaskGroup") : class$com$ibm$hwmca$fw$managed$TaskGroup).getName());
                objectId.setKeyProperty("Name", TaskDefinitionXML.getValue(nextNode));
                group = (TaskGroup)mom.get(objectId);
                NodeList children = groupElement.getElementsByTagName("children");
                if (children.getLength() <= 0) continue;
                nextNode = children.item(0);
                TaskDefinitionXML.updateChildrenOfGroup(group, tasks, taskGroups, (Element)nextNode, true);
                continue;
            }
            NodeList groupChildNodes = groupElement.getChildNodes();
            for (int j = 0; j < groupChildNodes.getLength(); ++j) {
                Node nextNode = groupChildNodes.item(j);
                if (nextNode.getNodeType() != 1) continue;
                if (nextNode.getNodeName().equalsIgnoreCase("key")) {
                    groupName = TaskDefinitionXML.getValue(nextNode);
                    continue;
                }
                if (nextNode.getNodeName().equalsIgnoreCase("uiinfo")) {
                    groupUIInfo = TaskDefinitionXML.createUIInfo(nextNode);
                    continue;
                }
                if (nextNode.getNodeName().equalsIgnoreCase("children")) {
                    groupChildren = (Element)nextNode;
                    continue;
                }
                if (!nextNode.getNodeName().equalsIgnoreCase("root")) continue;
                groupRoot = TaskDefinitionXML.getValue(nextNode);
            }
            group = new TaskGroup(groupName, groupUIInfo);
            Trace.trace(TRACE_MASKF, "   name is [" + groupName + "], root is [" + groupRoot + "]");
            if (groupRoot != null) {
                group.setRoot(Boolean.valueOf(groupRoot));
            }
            TaskDefinitionXML.updateChildrenOfGroup(group, tasks, taskGroups, groupChildren, true);
            mom.add(group);
            taskGroups.put(group.getName(), group);
        }
        Trace.trace(TRACE_MASKF, "   <- TaskDefinitionXML.createTaskGroups()");
        return taskGroups;
    }

    private static HashMap createTasks(Document doc, HashMap tasks) throws ClassNotFoundException {
        Trace.trace(TRACE_MASKF, "   -> TaskDefinitionXML.createTasks()");
        NodeList nodes = doc.getElementsByTagName("task");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node nextNode = nodes.item(i);
            if (nextNode.getNodeType() != 1) continue;
            try {
                Node keyNode;
                Task task = null;
                UIInfo uiInfo = null;
                NodeList childNodes = nextNode.getChildNodes();
                HashMap<String, Node> nodeMap = new HashMap<String, Node>();
                ArrayList<Node> acceptableTypes = new ArrayList<Node>();
                ArrayList<Node> taskletNames = new ArrayList<Node>();
                for (int k = 0; k < childNodes.getLength(); ++k) {
                    Node nextChildNode = childNodes.item(k);
                    String name = nextChildNode.getNodeName().toLowerCase();
                    if (name != null && name.equals("acceptabletype")) {
                        acceptableTypes.add(nextChildNode);
                        continue;
                    }
                    if (name != null && name.equals("taskletclass")) {
                        taskletNames.add(nextChildNode);
                        continue;
                    }
                    nodeMap.put(name, nextChildNode);
                }
                Node valueNode = (Node)nodeMap.get("uiinfo");
                if (valueNode != null) {
                    uiInfo = TaskDefinitionXML.createUIInfo(valueNode);
                }
                if ((keyNode = (Node)nodeMap.get("key")) != null) {
                    String key = TaskDefinitionXML.getValue(keyNode);
                    Trace.trace(TRACE_MASKD, "Creating task with key: " + key);
                    valueNode = (Node)nodeMap.get("class");
                    if (valueNode != null) {
                        Trace.trace(TRACE_MASKD, "   Task has classname: " + TaskDefinitionXML.getValue(valueNode));
                        Class[] aClass = new Class[]{key.getClass(), class$com$ibm$hwmca$fw$ui$UIInfo == null ? TaskDefinitionXML.class$("com.ibm.hwmca.fw.ui.UIInfo") : class$com$ibm$hwmca$fw$ui$UIInfo};
                        Class<?> taskClass = Class.forName(TaskDefinitionXML.getValue(valueNode));
                        Constructor<?> ctor = taskClass.getConstructor(aClass);
                        Object[] args = new Object[]{key, uiInfo};
                        task = (Task)ctor.newInstance(args);
                        if (task instanceof TaskChecker) {
                            TaskChecker taskChecker = (TaskChecker)((Object)task);
                            taskChecker.parseTaskNode(nextNode);
                        }
                    } else {
                        task = new Task(key, uiInfo);
                    }
                    int numAcceptableTypes = acceptableTypes.size();
                    if (numAcceptableTypes == 0) {
                        task.setTargetRequired(false);
                    } else {
                        for (int k = 0; k < numAcceptableTypes; ++k) {
                            valueNode = (Node)acceptableTypes.get(k);
                            if (valueNode == null) continue;
                            Element nextElement = (Element)valueNode;
                            String attributeValue = nextElement.getAttribute("allow");
                            if (attributeValue != null && attributeValue.length() > 0) {
                                if (attributeValue.compareToIgnoreCase("any") == 0) {
                                    task.setAnyPermitted(true);
                                    continue;
                                }
                                if (attributeValue.compareToIgnoreCase("none") != 0) continue;
                                task.setTargetRequired(false);
                                continue;
                            }
                            attributeValue = nextElement.getAttribute("prompt");
                            if (attributeValue.equalsIgnoreCase("true") || attributeValue.equalsIgnoreCase("yes")) {
                                Trace.trace(TRACE_MASKD, "   Task has prompt for targets value of: " + attributeValue);
                                task.setPromptForTargets(true);
                                continue;
                            }
                            Trace.trace(TRACE_MASKD, "   Task has acceptable type of: " + TaskDefinitionXML.getValue(valueNode));
                            if (TaskDefinitionXML.getValue(valueNode).length() <= 0) continue;
                            task.addPermittedObject(TaskDefinitionXML.getValue(valueNode));
                        }
                    }
                    for (int k = 0; k < taskletNames.size(); ++k) {
                        valueNode = (Node)taskletNames.get(k);
                        if (valueNode == null) continue;
                        String value = TaskDefinitionXML.getValue(valueNode);
                        Trace.trace(TRACE_MASKD, "   Task has associated tasklet of: " + value);
                        task.addAssociatedTasklet(value);
                    }
                    valueNode = (Node)nodeMap.get("remote");
                    if (valueNode != null) {
                        String value = TaskDefinitionXML.getValue(valueNode);
                        Trace.trace(TRACE_MASKD, "   Task has remote value of: " + value);
                        if (value.equals("false") || value.equals("no")) {
                            task.setCanExecuteRemotely(false);
                        }
                    }
                    if ((valueNode = (Node)nodeMap.get("singletarget")) != null) {
                        String value = TaskDefinitionXML.getValue(valueNode);
                        Trace.trace(TRACE_MASKD, "   Task has single target value of: " + value);
                        if (value.equals("true") || value.equals("yes")) {
                            task.setSingleTarget(true);
                        }
                    }
                    if ((valueNode = (Node)nodeMap.get("busytargets")) != null) {
                        String value = TaskDefinitionXML.getValue(valueNode);
                        Trace.trace(TRACE_MASKD, "   Task has busy targets value of: " + value);
                        if (value.equals("false") || value.equals("no")) {
                            task.setBusyTargets(false);
                        }
                    }
                    if ((valueNode = (Node)nodeMap.get("acceptbusytargets")) != null) {
                        String value = TaskDefinitionXML.getValue(valueNode);
                        Trace.trace(TRACE_MASKD, "   Task has accepts busy targets value of: " + value);
                        if (value.equals("true") || value.equals("yes")) {
                            task.setAcceptsBusyTargets(true);
                        }
                    }
                    if ((valueNode = (Node)nodeMap.get("updatetargetslasttaskname")) != null) {
                        String value = TaskDefinitionXML.getValue(valueNode);
                        Trace.trace(TRACE_MASKD, "   Task has update targets last task name value of: " + value);
                        if (value.equals("false") || value.equals("no")) {
                            task.setUpdateTargetsLastTaskName(false);
                        }
                    }
                    if ((valueNode = (Node)nodeMap.get("confirmationtext")) != null) {
                        TaskDefinitionXML.setConfirmationText(valueNode, task);
                    }
                    if ((valueNode = (Node)nodeMap.get("presentationclass")) != null) {
                        Trace.trace(TRACE_MASKD, "   Task has presentation task class name of: " + TaskDefinitionXML.getValue(valueNode));
                        task.setPresentationTaskClassName(TaskDefinitionXML.getValue(valueNode));
                    }
                    if ((valueNode = (Node)nodeMap.get("disruptive")) != null) {
                        String value = TaskDefinitionXML.getValue(valueNode);
                        Trace.trace(TRACE_MASKD, "   Task has disruptive value of: " + value);
                        if (value.equals("true") || value.equals("yes")) {
                            task.setDisruptive(true);
                        }
                    }
                    if ((valueNode = (Node)nodeMap.get("requirecommunications")) != null) {
                        String value = TaskDefinitionXML.getValue(valueNode);
                        Trace.trace(TRACE_MASKD, "   Task has require communications value of: " + value);
                        if (value.equals("true") || value.equals("yes")) {
                            task.setRequireCommunications(true);
                        }
                    }
                    if ((valueNode = (Node)nodeMap.get("mergedkey")) != null) {
                        String value = TaskDefinitionXML.getValue(valueNode);
                        Trace.trace(TRACE_MASKD, "   Task has a merged key value of: " + value);
                        task.setMergedKey(value);
                    }
                    if ((valueNode = (Node)nodeMap.get("relock")) != null) {
                        String value = TaskDefinitionXML.getValue(valueNode);
                        Trace.trace(TRACE_MASKD, "   Task has relock value of: " + value);
                        if (value.equals("false") || value.equals("no")) {
                            task.setRelockAllowed(false);
                        }
                    }
                }
                tasks.put(task.getName(), task);
                mom.add(task);
                continue;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Exception creating a task: " + e);
            }
        }
        Trace.trace(TRACE_MASKF, "   <- TaskDefinitionXML.createTasks()");
        return tasks;
    }

    private static HashMap removeTasks(Document doc, HashMap tasks) throws ClassNotFoundException {
        Trace.trace(TRACE_MASKF, "   -> TaskDefinitionXML.removeTasks()");
        NodeList nodes = doc.getElementsByTagName("task");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node nextNode = nodes.item(i);
            if (nextNode.getNodeType() != 1) continue;
            try {
                Node keyNode;
                Task task = null;
                UIInfo uiInfo = null;
                NodeList childNodes = nextNode.getChildNodes();
                HashMap<String, Node> nodeMap = new HashMap<String, Node>();
                ArrayList<Node> acceptableTypes = new ArrayList<Node>();
                ArrayList<Node> taskletNames = new ArrayList<Node>();
                for (int k = 0; k < childNodes.getLength(); ++k) {
                    Node nextChildNode = childNodes.item(k);
                    String name = nextChildNode.getNodeName().toLowerCase();
                    if (name != null && name.equals("acceptabletype")) {
                        acceptableTypes.add(nextChildNode);
                        continue;
                    }
                    if (name != null && name.equals("taskletclass")) {
                        taskletNames.add(nextChildNode);
                        continue;
                    }
                    nodeMap.put(name, nextChildNode);
                }
                Node valueNode = (Node)nodeMap.get("uiinfo");
                if (valueNode != null) {
                    uiInfo = TaskDefinitionXML.createUIInfo(valueNode);
                }
                if ((keyNode = (Node)nodeMap.get("key")) == null) continue;
                String key = TaskDefinitionXML.getValue(keyNode);
                Trace.trace(TRACE_MASKD, "Creating task with key: " + key);
                valueNode = (Node)nodeMap.get("class");
                if (valueNode != null) {
                    Trace.trace(TRACE_MASKD, "   Task has classname: " + TaskDefinitionXML.getValue(valueNode));
                    Class[] aClass = new Class[]{key.getClass(), class$com$ibm$hwmca$fw$ui$UIInfo == null ? TaskDefinitionXML.class$("com.ibm.hwmca.fw.ui.UIInfo") : class$com$ibm$hwmca$fw$ui$UIInfo};
                    Class<?> taskClass = Class.forName(TaskDefinitionXML.getValue(valueNode));
                    Constructor<?> ctor = taskClass.getConstructor(aClass);
                    Object[] args = new Object[]{key, uiInfo};
                    task = (Task)ctor.newInstance(args);
                } else {
                    task = new Task(key, uiInfo);
                }
                mom.remove(task.getObjectId());
                continue;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Exception creating a task: " + e);
            }
        }
        Trace.trace(TRACE_MASKF, "   <- TaskDefinitionXML.removeTasks()");
        return tasks;
    }

    private static HashMap removeTaskGroups(Document doc, HashMap tasks) throws HException {
        Trace.trace(TRACE_MASKF, "   -> TaskDefinitionXML.removeTaskGroups()");
        NodeList nodes = doc.getElementsByTagName("taskgroup");
        for (int i = 0; i < nodes.getLength(); ++i) {
            TaskGroup group = null;
            String groupName = null;
            Element groupChildren = null;
            Element groupElement = (Element)nodes.item(i);
            if (groupElement.getAttribute("type").equals("addtasks")) {
                NodeList keys = groupElement.getElementsByTagName("key");
                if (keys.getLength() <= 0) continue;
                Node nextNode = keys.item(0);
                ObjectId objectId = new ObjectId((class$com$ibm$hwmca$fw$managed$TaskGroup == null ? TaskDefinitionXML.class$("com.ibm.hwmca.fw.managed.TaskGroup") : class$com$ibm$hwmca$fw$managed$TaskGroup).getName());
                objectId.setKeyProperty("Name", TaskDefinitionXML.getValue(nextNode));
                group = (TaskGroup)mom.get(objectId);
                NodeList children = groupElement.getElementsByTagName("children");
                if (children.getLength() <= 0) continue;
                nextNode = children.item(0);
                TaskDefinitionXML.updateChildrenOfGroup(group, tasks, null, (Element)nextNode, false);
                continue;
            }
            NodeList groupChildNodes = groupElement.getChildNodes();
            for (int j = 0; j < groupChildNodes.getLength(); ++j) {
                Node nextNode = groupChildNodes.item(j);
                if (nextNode.getNodeType() != 1) continue;
                if (nextNode.getNodeName().equalsIgnoreCase("key")) {
                    groupName = TaskDefinitionXML.getValue(nextNode);
                    continue;
                }
                if (!nextNode.getNodeName().equalsIgnoreCase("children")) continue;
                groupChildren = (Element)nextNode;
            }
            ObjectId objectId = new ObjectId((class$com$ibm$hwmca$fw$managed$TaskGroup == null ? TaskDefinitionXML.class$("com.ibm.hwmca.fw.managed.TaskGroup") : class$com$ibm$hwmca$fw$managed$TaskGroup).getName());
            objectId.setKeyProperty("Name", groupName);
            group = (TaskGroup)mom.get(objectId);
            mom.remove(group.getObjectId());
        }
        Trace.trace(TRACE_MASKF, "   <- TaskDefinitionXML.removeTaskGroups()");
        return tasks;
    }

    private static void setConfirmationText(Node node, Task task) {
        NodeList nodes = node.getChildNodes();
        String bundleName = null;
        String key = null;
        for (int i = 0; i < nodes.getLength() && bundleName == null; ++i) {
            Node nextNode = nodes.item(i);
            if (nextNode.getNodeName().equalsIgnoreCase("resourcebundle")) {
                bundleName = TaskDefinitionXML.getValue(nextNode);
                continue;
            }
            if (!nextNode.getNodeName().equalsIgnoreCase("text")) continue;
            key = TaskDefinitionXML.getValue(nextNode);
        }
        if (key != null) {
            task.setConfirmationText(new LocalizableText(bundleName, key, null));
        }
    }

    private static UIInfo createUIInfo(Node node) {
        Trace.trace(TRACE_MASKF, "   -> TaskDefinitionXML.createUIInfo()");
        String name = null;
        String caption = null;
        String bundleName = null;
        ImageNodeData image = null;
        ImageNodeData tinyImage = null;
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node nextNode = nodes.item(i);
            if (nextNode.getNodeName().equalsIgnoreCase("name")) {
                name = TaskDefinitionXML.getValue(nextNode);
                continue;
            }
            if (nextNode.getNodeName().equalsIgnoreCase("caption")) {
                caption = TaskDefinitionXML.getValue(nextNode);
                continue;
            }
            if (nextNode.getNodeName().equalsIgnoreCase("image")) {
                image = new ImageNodeData(nextNode);
                continue;
            }
            if (nextNode.getNodeName().equalsIgnoreCase("tinyimage")) {
                tinyImage = new ImageNodeData(nextNode);
                continue;
            }
            if (!nextNode.getNodeName().equalsIgnoreCase("resourcebundle")) continue;
            bundleName = TaskDefinitionXML.getValue(nextNode);
        }
        UIInfo uiInfo = null;
        if (name != null && image != null && caption != null) {
            uiInfo = bundleName == null ? new UIInfo(new LocalizableText(name), new LocalizableText(caption), image.getImageName()) : new UIInfo(new LocalizableText(bundleName, name), new LocalizableText(bundleName, caption), image.getImageName());
            uiInfo.setImageURL(image.getImageURL());
            if (tinyImage != null) {
                uiInfo.setTinyImageName(tinyImage.getImageName());
                uiInfo.setTinyImageURL(tinyImage.getImageURL());
            }
        }
        Trace.trace(TRACE_MASKF, "   <- TaskDefinitionXML.createUIInfo()");
        return uiInfo;
    }

    private static void updateChildrenOfGroup(TaskGroup group, HashMap tasks, HashMap taskGroups, Element element, boolean add) throws HException {
        Trace.trace(TRACE_MASKF, "   -> TaskDefinitionXML.updateChildrenOfGroup()");
        NodeList keys = element.getElementsByTagName("key");
        for (int i = 0; i < keys.getLength(); ++i) {
            Node nextNode = keys.item(i);
            String key = TaskDefinitionXML.getValue(nextNode);
            HwmcaObject task = (HwmcaObject)tasks.get(key);
            if (task == null) {
                Trace.trace(TRACE_MASKF, "child with key [" + key + "] not a task; will try a task group");
                if (taskGroups != null) {
                    task = (HwmcaObject)taskGroups.get(key);
                }
                if (task == null) {
                    task = TaskDefinitionXML.getTaskFromMom(key);
                }
                if (task == null) {
                    task = TaskDefinitionXML.getTaskGroupFromMom(key);
                }
            }
            if (task == null) {
                String text = "TaskDefinitionXML.updateChildrenOfGroup() error:\ngroup [" + group.getName() + "] contains task id [" + key + "] but the task/taskgroup id does not exist.";
                new FrameworkLog(classLogInfo, 1183, new HException(text)).log();
                continue;
            }
            if (add) {
                group.addChild(task.getObjectId());
                continue;
            }
            group.removeChild(task.getObjectId());
        }
        Trace.trace(TRACE_MASKF, "   <- TaskDefinitionXML.updateChildrenOfGroup()");
    }

    private static void updateRoleTasks(UserRole role, HashMap tasks, Element element, boolean add) throws HException {
        Trace.trace(TRACE_MASKF, "   -> TaskDefinitionXML.updateRoleTasks()");
        ArrayList<ObjectId> permittedObjects = new ArrayList<ObjectId>();
        NodeList keys = element.getElementsByTagName("key");
        for (int i = 0; i < keys.getLength(); ++i) {
            Node nextNode = keys.item(i);
            String key = TaskDefinitionXML.getValue(nextNode);
            HwmcaObject task = (Task)tasks.get(key);
            if (task == null) {
                task = TaskDefinitionXML.getTaskFromMom(key);
            }
            if (task == null) {
                task = TaskDefinitionXML.getTaskGroupFromMom(key);
            }
            if (task == null) {
                String text = "TaskDefinitionXML.updateRoleTasks() error:\ngroup [" + role.getUIInfo().getName() + "] contains task id [" + key + "] but the task id does not exist.";
                new FrameworkLog(classLogInfo, 1183, new HException(text)).log();
                continue;
            }
            if (add) {
                permittedObjects.add(task.getObjectId());
                continue;
            }
            System.out.println("add remove");
        }
        role.addPermittedObjects(permittedObjects);
        Trace.trace(TRACE_MASKF, "   <- TaskDefinitionXML.updateRoleTasks()");
    }

    private static void updateRoleTaskGroups(UserRole role, HashMap taskGroups, Element element, boolean add) throws HException {
        Trace.trace(TRACE_MASKF, "   -> TaskDefinitionXML.updateRoleTaskGroups()");
        ArrayList<ObjectId> permittedObjects = new ArrayList<ObjectId>();
        NodeList keys = element.getElementsByTagName("key");
        for (int i = 0; i < keys.getLength(); ++i) {
            Node nextNode = keys.item(i);
            String key = TaskDefinitionXML.getValue(nextNode);
            TaskGroup taskGroup = (TaskGroup)taskGroups.get(key);
            if (taskGroup == null) {
                taskGroup = TaskDefinitionXML.getTaskGroupFromMom(key);
            }
            if (taskGroup == null) {
                String text = "TaskDefinitionXML.updateRoleTaskGroups() error:\ngroup [" + role.getUIInfo().getName() + "] contains task group id [" + key + "] but the task group id does not exist.";
                new FrameworkLog(classLogInfo, 1183, new HException(text)).log();
                continue;
            }
            if (add) {
                permittedObjects.add(taskGroup.getObjectId());
                continue;
            }
            System.out.println("need remove here");
        }
        role.addPermittedObjects(permittedObjects);
        Trace.trace(TRACE_MASKF, "   <- TaskDefinitionXML.updateRoleTaskGroups()");
    }

    private static Task getTaskFromMom(String key) {
        Trace.trace(TRACE_MASKF, "   -> TaskDefinitionXML.getTaskFromMom()");
        Set objs = mom.getInventory(taskClassId);
        Iterator iterator = objs.iterator();
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            ObjectId objectId = task.getObjectId();
            if (!key.equals(objectId.getKeyProperty("Name"))) continue;
            return task;
        }
        return null;
    }

    private static TaskGroup getTaskGroupFromMom(String key) {
        Trace.trace(TRACE_MASKF, "   -> TaskDefinitionXML.getTaskGroupFromMom()");
        Set objs = mom.getInventory(taskgroupClassId);
        Iterator iterator = objs.iterator();
        while (iterator.hasNext()) {
            TaskGroup taskGroup = (TaskGroup)iterator.next();
            ObjectId objectId = taskGroup.getObjectId();
            if (!key.equals(objectId.getKeyProperty("Name"))) continue;
            return taskGroup;
        }
        return null;
    }

    private static String getValue(Node node) {
        return HwmcaParser.getValue(node);
    }

    private static void updateRoleManagedObjects(UserRole role, Element node, boolean add) throws HException {
        Trace.trace(TRACE_MASKF, "   -> TaskDefinitionXML.updateRoleManagedObjects()");
        String packageName = null;
        String className = null;
        if (node != null) {
            NodeList nodes = node.getElementsByTagName("group");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element groupElement = (Element)nodes.item(i);
                NodeList groupChildNodes = groupElement.getChildNodes();
                for (int j = 0; j < groupChildNodes.getLength(); ++j) {
                    Node nextNode = groupChildNodes.item(j);
                    if (nextNode.getNodeType() != 1) continue;
                    if (nextNode.getNodeName().equalsIgnoreCase("classid")) {
                        packageName = TaskDefinitionXML.getValue(nextNode);
                        continue;
                    }
                    if (!nextNode.getNodeName().equalsIgnoreCase("class")) continue;
                    className = TaskDefinitionXML.getValue(nextNode);
                }
                role.addPermittedObject(new ClassId(packageName, className));
            }
        }
        Trace.trace(TRACE_MASKF, "   <- TaskDefinitionXML.updateRoleManagedObjects()");
    }

    private static void updateChildrenOfRole(UserRole role, HashMap tasks, Element element, boolean add) throws HException {
        Trace.trace(TRACE_MASKF, "   -> TaskDefinitionXML.updateChildrenOfRole()");
        NodeList keys = element.getElementsByTagName("key");
        for (int i = 0; i < keys.getLength(); ++i) {
            Node nextNode = keys.item(i);
            String key = TaskDefinitionXML.getValue(nextNode);
            Task task = (Task)tasks.get(key);
            if (task == null) {
                task = TaskDefinitionXML.getTaskFromMom(key);
            }
            if (task == null) {
                String text = "TaskDefinitionXML.updateChildrenOfRole() error:\ngroup [" + role.getUIInfo().getName() + "] contains task id [" + key + "] but the task id does not exist.";
                new FrameworkLog(classLogInfo, 1183, new HException(text)).log();
                continue;
            }
            if (add) {
                role.addPermittedObject(task.getObjectId());
                continue;
            }
            System.out.println("remove not done yet");
        }
        Trace.trace(TRACE_MASKF, "   <- TaskDefinitionXML.updateChildrenOfRole()");
    }

    public static List getUIBooks(String fileName, List books) throws HException {
        Trace.trace(TRACE_MASKT, "-> TaskDefinitionXML.getUIBooks()");
        Trace.trace(TRACE_MASKF, "   fileName is [" + fileName + "]");
        try {
            FileInputStream fis = new FileInputStream(fileName);
            Document doc = new HwmcaParser(fis, false).getDocument();
            TaskDefinitionXML.createUIBooks(doc, books);
        }
        catch (Exception exc) {
            HException hexc = new HException(exc);
            String text = "TaskDefinitionXML.getUIBooks(String)\ncaught Exception while processing XML file [" + fileName + "]";
            hexc.add(text);
            throw hexc;
        }
        Trace.trace(TRACE_MASKT, "<- TaskDefinitionXML.getUIBooks()");
        return books;
    }

    private static void createUIBooks(Document doc, List books) throws HException {
        NodeList nodes = doc.getElementsByTagName("uibook");
        for (int i = 0; i < nodes.getLength(); ++i) {
            UIInfo uiInfo = null;
            String key = null;
            String url = null;
            NodeList childNodes = nodes.item(i).getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node nextNode = childNodes.item(j);
                if (nextNode.getNodeType() != 1) continue;
                if (nextNode.getNodeName().equalsIgnoreCase("key")) {
                    key = TaskDefinitionXML.getValue(nextNode);
                    continue;
                }
                if (nextNode.getNodeName().equalsIgnoreCase("uiinfo")) {
                    uiInfo = TaskDefinitionXML.createUIInfo(nextNode);
                    continue;
                }
                if (!nextNode.getNodeName().equalsIgnoreCase("relurl")) continue;
                url = TaskDefinitionXML.getValue(nextNode);
            }
            if (uiInfo == null || key == null || url == null) {
                Trace.trace(TRACE_MASKF, "Error, could not create UIBook object.  Data from XML file is...");
                Trace.trace(TRACE_MASKF, "   key is    [" + key + "]");
                Trace.trace(TRACE_MASKF, "   relurl is [" + url + "]");
                Trace.trace(TRACE_MASKF, "   uiInfo is [" + uiInfo + "]");
                continue;
            }
            Trace.trace(TRACE_MASKF, "   create UIBook with a key of [" + key + "]");
            books.add(new UIBook(key, uiInfo, url));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

